{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:21:28 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMHook, MMDesign, MMObj, MMDIBCv, MMLevel, MMConect, MMWavOut,
  MMSystem,MMDSPObj, MMWavIn, MMwaveIO;

type
  TForm1 = class(TForm)
    WaveIn: TMMWaveIn;
    WaveOut: TMMWaveOut;
    MMConnector1: TMMConnector;
    MMConnector2: TMMConnector;
    MMLevel1: TMMLevel;
    MMDesigner1: TMMDesigner;
    btnRecord: TButton;
    btnPlay: TButton;
    btnStop: TButton;
    procedure WaveInStart(Sender: TObject);
    procedure WaveInStop(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure WaveInBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnRecordClick(Sender: TObject);
    procedure btnPlayClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure WaveOutStart(Sender: TObject);
    procedure WaveOutStop(Sender: TObject);
    procedure WaveOutBufferLoad(Sender: TObject; lpWaveHdr: PWaveHdr;
      var MoreBuffers: Boolean);
  private
  public
    MemStream: TMemoryStream;
    BytesRecorded: Longint;
    BytesPlayed  : Longint;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{------------------------------------------------------------------------------}
procedure TForm1.FormCreate(Sender: TObject);
begin
   MemStream := TMemoryStream.Create;
end;

{------------------------------------------------------------------------------}
procedure TForm1.FormDestroy(Sender: TObject);
begin
   MemStream.Free;
end;

{------------------------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   WaveIn.Close;
   WaveOut.Close;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveInStart(Sender: TObject);
begin
   { set the stream size for max speed }
   MemStream.SetSize(wioTimeToBytes(WaveIn.PWaveFormat,WaveIn.MaxRecordTime));
   MemStream.Position := 0;
   BytesRecorded := 0;

   btnRecord.Enabled := False;
   btnPlay.Enabled := False;
   btnStop.Enabled := True;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveInStop(Sender: TObject);
begin
   WaveIn.Close;
   btnPlay.Enabled := True;
   btnRecord.Enabled := True;
   btnStop.Enabled := False;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveInBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
begin
   { we got new data from WaveIn, put it in the stream }
   MemStream.Write(lpWaveHdr^.lpData^, lpWaveHdr^.dwBytesRecorded);
   inc(BytesRecorded,lpWaveHdr^.dwBytesRecorded);
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveOutStart(Sender: TObject);
begin
   btnRecord.Enabled := False;
   btnPlay.Enabled := False;
   btnStop.Enabled := True;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveOutStop(Sender: TObject);
begin
   WaveOut.Close;
   btnPlay.Enabled := True;
   btnRecord.Enabled := True;
   btnStop.Enabled := False;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveOutBufferLoad(Sender: TObject; lpWaveHdr: PWaveHdr; var MoreBuffers: Boolean);
var
   nBytes: Longint;
begin
   { how many bytes do we need for this buffer }
   nBytes := lpWaveHdr^.dwBufferLength;

   { do we have enough data ? }
   if (BytesRecorded-BytesPlayed < nBytes) then
       nBytes := BytesRecorded-BytesPlayed;

   { WaveOut needs Data, get it from the stream }
   Move((PChar(MemStream.Memory)+BytesPlayed)^, lpWaveHdr^.lpData^,nBytes);

   { flag how many bytes we have loaded }
   lpWaveHdr^.dwBytesRecorded := nBytes;

   { and increase our counter }
   inc(BytesPlayed, nBytes);

   { flag if we have more data to play }
   MoreBuffers := BytesPlayed < BytesRecorded;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnRecordClick(Sender: TObject);
begin
   { start recording }
   WaveIn.Start;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnPlayClick(Sender: TObject);
begin
   { Waveout has no input component, se we must tell him the wave format ! }
   WaveOut.PWaveFormat := WaveIn.PWaveFormat;

   { reset our counter }
   BytesPlayed := 0;

   { and start it playing }
   WaveOut.Start;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnStopClick(Sender: TObject);
begin
   WaveIn.Stop;
   WaveOut.Stop;
end;

end.
